# Release

CLI for [Release](https://release.com/)

## Docs

For installation and usage instructions [see the docs](https://docs.release.com/cli/).

## Contributing

### Building & Running

To build, clone the repository and run:

```
make build
```

To build and install to your /usr/local/bin:

```
make install
```

### Testing

Libraries used in testing:

- [`go-vcr`](https://github.com/dnaeon/go-vcr) - Records and replays API requests
  and responses in tests
- [`cupaloy`](https://github.com/bradleyjkemp/cupaloy) - Compares command output to
  snapshot files to avoid unintended changes
- [`testscript`](https://pkg.go.dev/github.com/rogpeppe/go-internal/testscript) -
  Runs the CLI end-to-end and makes assertion on exit status, stdout/stderr, etc.

To run all tests:

```
make test
```

To generate code coverage:

```
make coverage
```

To run end-to-end tests:

```
make test-e2e
```

### Directory Structure

We follow the [Standard Go Project Layout](https://github.com/golang-standards/project-layout) convention wherever possible.

### VHS

We use the [VHS](https://github.com/charmbracelet/vhs) projcet to generate new copies of the tutorial gifs, type `make vhs`

They will output to vhs_out/

### Publishing a Release

Create a new tag `git tag v0.12.0-beta`

Then push it `git push origin v0.12.0-beta`

[GitHub actions](https://github.com/releasehub-com/cli/actions) will take care of the rest.

## GraphQL

To export a fresh schema file from spacedust/backend run `bin/rails graphql:schema:idl`

Then move it into the cli directory `cp app/graphql/schema.graphql ../../cli/schema.graphql`

Now run genqlient with `go run github.com/Khan/genqlient`

## Syncthing

The remote development features use [Syncthing](https://syncthing.net/) to sync files with
remote containers. We embed Syncthing as a library. Because Syncthing does not commit their generated
GUI assets and it's not possible to automatically run `go generate` on a dependency module,
we use [a fork](https://github.com/releasehub-com/syncthing) that commits the generated assets.

To update that fork to a new version:

Clone the fork locally, checkout a new branch based on the desired tag and run:

```bash
# Change to the desired base tag
export TAG=v1.27.9

git checkout -b
git rm ./lib/api/auto/.gitignore
go generate ./lib/api/auto
git add .
git commit -m "Commit generated assets"
git tag "${TAG}-with-assets"
git push --tags
```

Then update the `replace` directive in `go.mod` to point to the new tag.