# Release

CLI for [Release](https://release.com/)

## Docs

For installation and usage instructions [see the docs](https://docs.release.com/cli/).

## Contributing

### Building & Running

To build, clone the repository and run:

```
go build ./cmd/release
```

To build and install to your /usr/local/bin:

```
make install
```

### Testing

Libraries used in testing:

* [`go-vcr`](https://github.com/dnaeon/go-vcr) - Records and replays API requests
and responses in tests
* [`cupaloy`](https://github.com/bradleyjkemp/cupaloy) - Compares command output to
  snapshot files to avoid unintended changes

To run all tests:

```
make test
```

To generate code coverage:

```
make coverage
```

### Directory Structure

We follow the [Standard Go Project Layout](https://github.com/golang-standards/project-layout) convention wherever possible.

### VHS

We use the [VHS](https://github.com/charmbracelet/vhs) projcet to generate new copies of the tutorial gifs, type `make vhs`

They will output to vhs_out/

### Publishing a Release

Create a new tag `git tag v0.12.0-beta`

Then push it `git push origin v0.12.0-beta`

[GitHub actions](https://github.com/releasehub-com/cli/actions) will take care of the rest.

## GraphQL

To export a fresh schema file from spacedust/backend run `bin/rails graphql:schema:idl`

Then move it into the cli directory `cp app/graphql/schema.graphql ../../cli/schema.graphql`

Now run genqlient with `go run github.com/Khan/genqlient`
